/*
 *  kexbases\kernel32\_kernel32_stubs.c
 *
 *  Copyright (C) 2008, Xeno86
 *  Copyright (C) 2016-2019, jumper
 *
 *  This file is part of KernelEx source code.
 *
 *  KernelEx is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published
 *  by the Free Software Foundation; version 2 of the License.
 *
 *  KernelEx is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "common.h"

#define ERROR_NS              50L
#define ERROR_NI             120L
#define HRESULT_NI    0x80004001L
#define STATUS_NI     0xC0000002L

  seUNIMPL_FUNC(CreateHardLinkA, 3, ERROR_NI);
  seUNIMPL_FUNC(CreateHardLinkW, 3, ERROR_NI);
   sUNIMPL_FUNC(IsValidLanguageGroup, 2);
  seUNIMPL_FUNC(ReplaceFileA, 6, ERROR_NI);
  seUNIMPL_FUNC(ReplaceFileW, 6, ERROR_NI);
  seUNIMPL_FUNC(HeapSetInformation, 4, ERROR_NI);  //f4e
  seUNIMPL_FUNC(GetProcessIoCounters, 2, ERROR_NI);
   sUNIMPL_FUNC(RtlCaptureStackBackTrace, 4);  //f4e0 ? here and ntdll
  seUNIMPL_FUNC(GetComputerNameExA, 3, ERROR_NI);
  seUNIMPL_FUNC(GetComputerNameExW, 3, ERROR_NI);
//seUNIMPL~FUNC(SetDllDirectoryA, 1, ERROR_NI);
//seUNIMPL~FUNC(SetDllDirectoryW, 1, ERROR_NI);

  se_UNIMPL_FUNC(GetLogicalProcessorInformation, 2, ERROR_NI);  //f2e ;MPC-HC1.7.7
  se_UNIMPL_FUNC(GetNumaHighestNodeNumber, 1, ERROR_NI);  //f1e ;msvcr110
  se_UNIMPL_FUNC(HeapQueryInformation,  5, ERROR_NI);  //f5e ;Slimboat 1.50
   s_UNIMPL_FUNC(WTSGetActiveConsoleSessionId, 0);  //z0 0=local session; -1=none

  se_UNIMPL_FUNC(GetSystemWow64DirectoryA, 2, ERROR_NI);  //z2e120 #65
  se_UNIMPL_FUNC(GetSystemWow64DirectoryW, 2, ERROR_NI);  //z2e120 #65 #304
  se_UNIMPL_FUNC(GetVolumeNameForVolumeMountPointA, 3, ERROR_NI);  //z3e120
  se_UNIMPL_FUNC(GetVolumeNameForVolumeMountPointW, 3, ERROR_NI);  //z3e120
  se_UNIMPL_FUNC(GetVolumePathNamesForVolumeNameA, 4, ERROR_NI);  //z4e120
  se_UNIMPL_FUNC(GetVolumePathNamesForVolumeNameW, 4, ERROR_NI);  //z4e120


/* Activation Context (ActCtx) */
rse_UNIMPL_FUNC(ActivateActCtx,            1, 2, 0  );  //o2e0
  s_UNIMPL_FUNC(AddRefActCtx,                 1     );  //z1
rse_UNIMPL_FUNC(CreateActCtxA,       [esp+4], 1, 0  );  //p1e0
rse_UNIMPL_FUNC(CreateActCtxW,       [esp+4], 1, 0  );  //p1e0
rse_UNIMPL_FUNC(DeactivateActCtx,          1, 2, 0  );  //o2e0
 se_UNIMPL_FUNC(FindActCtxSectionGuid,        5, ERROR_NI);  //f5e
 se_UNIMPL_FUNC(FindActCtxSectionStringA,     5, ERROR_NI);  //f5e
rse_UNIMPL_FUNC(FindActCtxSectionStringW,  1, 5, 0  );  //o5e0
 se_UNIMPL_FUNC(GetCurrentActCtx,             1, ERROR_NI);  //f1e
  s_UNIMPL_FUNC(IsolationAwareCleanup,        0     );  //z0
rse_UNIMPL_FUNC(QueryActCtxSettingsW,      1, 7, 0  );  //o7e0
rse_UNIMPL_FUNC(QueryActCtxW,              1, 7, 0  );  //o7e0
  s_UNIMPL_FUNC(ReleaseActCtx,                1     );  //z1
rse_UNIMPL_FUNC(ZombifyActCtx,             1, 1, 0  );  //o1e0

/* Singly-linked List (SList) *
  s_UNIMPL_FUNC(InitializeSListHead, 1);
  s_UNIMPL_FUNC(InterlockedFlushSList, 1);
  s_UNIMPL_FUNC(InterlockedPopEntrySList, 1);
  s_UNIMPL_FUNC(InterlockedPushEntrySList, 2);
  s_UNIMPL_FUNC(QueryDepthSList, 1);

/* Added in .11 from jumper's Kstub822.ini file */
   s_UNIMPL_FUNC(AddVectoredExceptionHandler, 2);  //z2
  se_UNIMPL_FUNC(AttachConsole, 1, ERROR_NI);  //f1e
  se_UNIMPL_FUNC(CheckNameLegalDOS8Dot3, 5, ERROR_NI);  //z5e
  se_UNIMPL_FUNC(CheckRemoteDebuggerPresent, 2, ERROR_NI);  //f2e120
  se_UNIMPL_FUNC(CreateMemoryResourceNotification, 1, ERROR_NI);  //z1e120
  se_UNIMPL_FUNC(DebugActiveProcessStop, 1, ERROR_NI);  //z1e120
  se_UNIMPL_FUNC(DebugSetProcessKillOnExit, 1, ERROR_NI);  //z1e120
  se_UNIMPL_FUNC(DnsHostnameToComputerNameW, 3, ERROR_NI);  //z3e120
 rse_UNIMPL_FUNC(FindFirstVolumeA, -1, 2, ERROR_NI);  //t2e120
 rse_UNIMPL_FUNC(FindFirstVolumeW, -1, 2, ERROR_NI);  //t2e120
  se_UNIMPL_FUNC(FindNextVolumeA, 3, ERROR_NI);  //z3e120
  se_UNIMPL_FUNC(FindNextVolumeW, 3, ERROR_NI);  //z3e120
  rs_UNIMPL_FUNC(FindVolumeClose, 1, 1);  //o1
 rse_UNIMPL_FUNC(FlsAlloc, -1, 1, ERROR_NI);  //t1e120 #jds !spdf1.9!
  se_UNIMPL_FUNC(FlsFree,      1, ERROR_NI);  //z1e120 #jds
  se_UNIMPL_FUNC(FlsGetValue,  1, ERROR_NI);  //z1e120 #jds
  se_UNIMPL_FUNC(FlsSetValue,  2, ERROR_NI);  //z2e120 #jds
  se_UNIMPL_FUNC(GetConsoleDisplayMode, 1, ERROR_NI);  //z1e120
  se_UNIMPL_FUNC(GetGeoInfoA, 5, ERROR_NI);  //z5e
  se_UNIMPL_FUNC(GetGeoInfoW, 5, ERROR_NI);  //z5e
  se_UNIMPL_FUNC(GetProcessHandleCount, 2, ERROR_NI);  //z2e120
  se_UNIMPL_FUNC(GetSystemRegistryQuota, 2, ERROR_NI);  //z2e120
  se_UNIMPL_FUNC(GetSystemTimes, 3, ERROR_NI);  //z3e120
  se_UNIMPL_FUNC(GetThreadId, 1, ERROR_NI);  //z1e120
  rs_UNIMPL_FUNC(GetUserGeoID, -1, 1);  //=t1 ;r244s1 US ;r94s1 Germany #54
  se_UNIMPL_FUNC(QueryMemoryResourceNotification, 2, ERROR_NI);  //z2e120
   s_UNIMPL_FUNC(RemoveVectoredExceptionHandler, 1);  //z1
  se_UNIMPL_FUNC(SetConsoleDisplayMode, 3, ERROR_NI);  //f3e120
  se_UNIMPL_FUNC(SetFileValidData, 3, ERROR_NI);  //z3e120
   s_UNIMPL_FUNC(WerRegisterMemoryBlock, 2);  //z2
/*
  rs_UNIMPL_FUNC(InitializeSRWLock, [esp+4] __asm push 0 __asm pop DWORD PTR[eax], 1);  //{ *p=0 } ; mshtlm urlmon ProEvSoccer2015
   s_UNIMPL_FUNC(AcquireSRWLockExclusive, 1);  // ProEvSoccer2015
   s_UNIMPL_FUNC(AcquireSRWLockShared,    1);  // ProEvSoccer2015
   s_UNIMPL_FUNC(ReleaseSRWLockExclusive, 1);  // ProEvSoccer2015
   s_UNIMPL_FUNC(ReleaseSRWLockShared,    1);  // ProEvSoccer2015
*/
 /* Added in .15 from jumper's Kstub822.ini file */
 rse_UNIMPL_FUNC(Wow64DisableWow64FsRedirection, TRUE, 1, 0);  //o1e0 f1e120 ** ;rpcrt4.ros ieframe.ros ;!PeStudio
  rs_UNIMPL_FUNC(Wow64EnableWow64FsRedirection,  TRUE, 1);     //o1
 rse_UNIMPL_FUNC(Wow64RevertWow64FsRedirection,  TRUE, 1, 0);  //o1e0 ** ;rpcrt4.ros ieframe.ros

  se_UNIMPL_FUNC(SetProcessDEPPolicy,  1, ERROR_NS);  //f1e50 #jds #Opera12.18

  /* Added in .19 */
 rse_UNIMPL_FUNC(PowerCreateRequest, -1, 1, ERROR_NI);  //t1e120 r<INVALID_HANDLE_VALUE>s1e
  se_UNIMPL_FUNC(PowerSetRequest,        2, ERROR_NI);  //f2e120
  se_UNIMPL_FUNC(PowerClearRequest,      2, ERROR_NI);  //f2e120

  /* Added in .21 */
  se_UNIMPL_FUNC(PrivCopyFileExW,        6, ERROR_NI);  //f6e  Battlefield2
  se_UNIMPL_FUNC(ResolveLocaleName,      3, ERROR_NI);  //z3e  soffice.bin(v6.0)
  se_UNIMPL_FUNC(QueryFullProcessImageNameA,  4, ERROR_NI);  //f4e
  se_UNIMPL_FUNC(QueryFullProcessImageNameW,  4, ERROR_NI);  //f4e  QT Creator 4.6

  /* Added in .22 */
  se_UNIMPL_FUNC(ConvertFiberToThread,        0, ERROR_NI);  //f0e120  schwups
  se_UNIMPL_FUNC(QueryThreadCycleTime,        2, ERROR_NI);  //f2e120

  /* Added in .24 */
  se_UNIMPL_FUNC(DebugBreakProcess,  1, ERROR_NI);  //z1e  xp: Northgard Relics
 rse_UNIMPL_FUNC(ReOpenFile,     -1, 4, ERROR_NI);  //rIFHs4e  2k3: FileZilla FTP client 3.43
  se_UNIMPL_FUNC(SetFileCompletionNotificationModes, 2, ERROR_NI);  //f2e  Vista: FZ 3.43

  se_UNIMPL_FUNC(FindFirstVolumeMountPointA,  3, ERROR_NI);  //f3e  ListUsbDrives 1.7.8.0 5/19/08
  se_UNIMPL_FUNC(FindFirstVolumeMountPointW,  3, ERROR_NI);  //f3e  ListUsbDrives 5.2.7.0 9/07/16
  se_UNIMPL_FUNC(FindNextVolumeMountPointA,   3, ERROR_NI);  //f3e  ListUsbDrives 1.7.8.0 5/19/08
  se_UNIMPL_FUNC(FindNextVolumeMountPointW,   3, ERROR_NI);  //f3e  ListUsbDrives 5.2.7.0 9/07/16
  se_UNIMPL_FUNC(FindVolumeMountPointClose,   1, ERROR_NI);  //f1e  ListUsbDrives 1.7.8.0 5/19/08, 5.2.7.0 9/07/16
